/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.LocalAlternativeGroup;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.Triple;
import cz.insophy.inplan.xml.InvalidXmlException;
import cz.insophy.inplan.xml.ShopSerializationException;
import cz.insophy.inplan.xml.XmlReader;
import cz.insophy.inplan.xml.XmlSource;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.xml.sax.SAXException;

public final class ShopSerializer {
    public static boolean validate = false;
    private static final String SHOP_NS_URI = "http://www.insophy.cz/inplan/shop";
    private static final String SHOP_XSD_URI = "http://www.insophy.cz/inplan/shop shop.xsd";
    private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final long DEFAULT_REBUILD_TIME = 300000L;

    private ShopSerializer() {
    }

    public static ShopConfiguration loadFromXml(URL url) throws InvalidXmlException {
        return ShopSerializer.loadFromXml(XmlSource.create(url));
    }

    public static ShopConfiguration loadFromXml(File file) throws InvalidXmlException {
        return ShopSerializer.loadFromXml(XmlSource.create(file));
    }

    public static ShopConfiguration loadFromXml(InputStream stream) throws InvalidXmlException {
        return ShopSerializer.loadFromXml(XmlSource.create(stream));
    }

    public static ShopConfiguration loadFromXml(byte[] xmlBytes) throws InvalidXmlException {
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlBytes);
        return ShopSerializer.loadFromXml(bais);
    }

    public static ShopConfiguration loadFromXml(@Nonnull XmlSource xmlSource) throws InvalidXmlException {
        Document doc;
        URL schema = ShopSerializer.class.getResource("shop.xsd");
        if (validate) {
            try {
                doc = XmlReader.readWithExternalXsdValidation(xmlSource, schema);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new InvalidXmlException("SaxReader initialization failed. The document could not be validated.", e);
            }
            catch (IOException e) {
                throw new InvalidXmlException("Xml source or validation schema could not be opened or read.", e);
            }
            catch (DocumentException e) {
                throw new InvalidXmlException("XML validation against shop.xsd failed.", e);
            }
        }
        try {
            doc = XmlReader.readWithoutValidation(xmlSource);
        }
        catch (DocumentException e) {
            throw new InvalidXmlException("Parsing of the document failed.", e);
        }
        catch (IOException e) {
            throw new InvalidXmlException("Xml source could not be opened or read.", e);
        }
        return new ShopConfParser(doc.getRootElement()).parse();
    }

    public static void storeToXml(ShopConfiguration shopConfig, OutputStream out) throws ShopSerializationException {
        try {
            new ShopConfWriter(shopConfig).writeConfiguration(out);
        }
        catch (XMLStreamException e) {
            throw new ShopSerializationException("An error occured during serialization of the configuration: " + e.getMessage());
        }
    }

    public static byte[] storeToXmlBytes(ShopConfiguration shopConfig) throws ShopSerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ShopSerializer.storeToXml(shopConfig, baos);
        return baos.toByteArray();
    }

    public static void storeToXml(ShopConfiguration shopConfig, File file) throws ShopSerializationException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            new ShopConfWriter(shopConfig).writeConfiguration(out);
        }
        catch (IOException | XMLStreamException e) {
            throw new ShopSerializationException("An error occurred during serialization of the configuration: " + e.getMessage(), e);
        }
    }

    public static void storeToXml(ShopConfiguration shopConfig, Writer writer) throws ShopSerializationException {
        try {
            new ShopConfWriter(shopConfig).writeConfiguration(writer);
        }
        catch (XMLStreamException e) {
            throw new ShopSerializationException("An error occured during serialization of the configuration: " + e.getMessage());
        }
    }

    public static class ShopConfParser {
        private final Element rootElement;
        private List<Material> matprods = new ArrayList<Material>();
        private final Map<String, Material> matprodLut = Maps.newHashMap();
        private Map<String, Element> matprodEls;
        private final Map<String, RebuildType> rebuildTypes = Maps.newHashMap();
        private final Multimap<String, RebuildType> wpRebuildTypes = ArrayListMultimap.create();
        private HashSet<String> matprodStack = new HashSet();
        private Map<Class<? extends Propertized>, PropertyDefinitions> propdefs;
        private Material.Builder materialBob = Material.newBuilder();
        private Product.Builder productBob = Product.newBuilder();

        public ShopConfParser(ShopConfiguration shop) {
            this.rootElement = null;
            this.matprodEls = new HashMap<String, Element>();
            for (Material material : shop.getMatprods()) {
                this.matprodLut.put(material.getName(), material);
            }
        }

        public ShopConfParser(Element rootElement) throws InvalidXmlException {
            this.rootElement = rootElement;
            HashSet<String> duplicates = ShopConfParser.checkDuplicates(rootElement);
            if (duplicates.size() > 0) {
                String dups = duplicates.toString();
                dups = dups.substring(0, Math.min(dups.length(), 300));
                throw new InvalidXmlException("The XML description contains duplicate matprods. " + dups);
            }
        }

        private ShopConfiguration parse() throws InvalidXmlException {
            this.propdefsFromXmlEl(this.rootElement.element("property-definitions"));
            this.materialsFromXmlEl(this.rootElement.element("materials"));
            this.matprodEls = ShopConfParser.matprodRefs(this.rootElement.element("products"));
            this.parseRebuildTypes();
            this.matprodsFromXmlEl(this.rootElement.element("products"));
            this.resolveProducibles();
            List<Workplace> workplaces = this.workplacesFromXmlEl(this.rootElement.element("workplaces"));
            return new ShopConfiguration(workplaces, this.matprods, this.propdefs);
        }

        private void propdefsFromXmlEl(Element element) throws InvalidXmlException {
            ArrayList<PropertyDefinition> pdList = Lists.newArrayList();
            if (element != null) {
                List<Element> elements = element.elements("property-definition");
                for (Element matEl : elements) {
                    String name = matEl.attributeValue("name");
                    String label = matEl.attributeValue("label");
                    String description = matEl.attributeValue("description", "");
                    String typeS = matEl.attributeValue("type", "").toUpperCase();
                    PropertyDefinition.PropertyType type = this.checkedEnumValue(PropertyDefinition.PropertyType.class, typeS, "Invalid property definition type");
                    String effectivityS = matEl.attributeValue("effectivity", "").toLowerCase();
                    Class effectivity = (Class)PropertyDefinition.PROPERTY_EFFECTIVITY_NAMES.inverse().get(effectivityS);
                    if (effectivity == null) {
                        throw new InvalidXmlException("Invalid property definition effectivity " + effectivityS);
                    }
                    String visibleS = matEl.attributeValue("visible", "true");
                    boolean visible = Boolean.parseBoolean(visibleS);
                    pdList.add(new PropertyDefinition(name, type, label, description, effectivity, visible));
                }
            }
            this.propdefs = PropertyDefinitions.splitPropertyDefinitions(pdList, true);
        }

        private Map<PropertyDefinition, String> propertiesFromXmlEl(Element element, Class<? extends Propertized> effectivity) throws InvalidXmlException {
            Preconditions.checkArgument("properties".equals(element.getName()));
            HashMap<PropertyDefinition, String> res = Maps.newHashMap();
            List<PropertyDefinition> propdefs = this.propdefs.containsKey(effectivity) ? this.propdefs.get(effectivity).getPropertyDefinitions() : Collections.emptyList();
            List<Element> elements = element.elements("property");
            for (Element propEl : elements) {
                String name = propEl.attributeValue("name");
                String value = propEl.attributeValue("value");
                PropertyDefinition propdef = null;
                for (PropertyDefinition pd : propdefs) {
                    if (!name.equals(pd.getName())) continue;
                    propdef = pd;
                    break;
                }
                if (propdef != null) {
                    res.put(propdef, value);
                    continue;
                }
                throw new InvalidXmlException("Invalid property " + name + " for " + effectivity.getSimpleName());
            }
            return res;
        }

        private <T extends Enum<T>> T checkedEnumValue(Class<T> enumClass, String val, String errMsg) throws InvalidXmlException {
            try {
                return Enum.valueOf(enumClass, val);
            }
            catch (Exception e) {
                throw new InvalidXmlException(errMsg + " " + val, e);
            }
        }

        private void parseRebuildTypes() throws InvalidXmlException {
            Element rtsEl = this.rootElement.element("rebuild-types");
            if (rtsEl != null) {
                this.parseRebuildTypesNormal(rtsEl);
            } else {
                this.parseRebuildTypesCompatible();
            }
        }

        private void parseRebuildTypesNormal(Element rtsEl) throws InvalidXmlException {
            for (Element rtEl : rtsEl.elements("rebuild-type")) {
                String id = rtEl.attributeValue("rid");
                String name = rtEl.attributeValue("name");
                String timeS = rtEl.attributeValue("time");
                long time = Long.parseLong(timeS);
                Element bomEl = rtEl.element("bom");
                Bom bom = this.bomFromXmlEl(bomEl);
                RebuildType rt = new RebuildType(name, time, bom);
                Element propsEl = rtEl.element("properties");
                if (propsEl != null) {
                    rt.setProperties(this.propertiesFromXmlEl(propsEl, RebuildType.class), this.propdefs.get(RebuildType.class));
                } else {
                    rt.setProperties(null, this.propdefs.get(RebuildType.class));
                }
                if (this.rebuildTypes.put(id, rt) == null) continue;
                throw new InvalidXmlException("Duplicate rebuild type id " + id);
            }
        }

        private List<Element> selectElems(String xpath) {
            XPath xPath = DocumentHelper.createXPath(xpath);
            xPath.setNamespaceURIs(Collections.singletonMap("s", ShopSerializer.SHOP_NS_URI));
            return Collections3.safeCast(xPath.selectNodes(this.rootElement), Element.class);
        }

        private void parseRebuildTypesCompatible() throws InvalidXmlException {
            ArrayListMultimap<String, String> capsWp = ArrayListMultimap.create();
            HashMap<String, Long> wpRebuildTimes = Maps.newHashMap();
            List<Element> wpEls = this.selectElems("/s:shop/s:workplaces/s:workplace");
            for (Element e : wpEls) {
                String rebuildTimeS;
                String wpName = e.attributeValue("name");
                String caps = e.attributeValue("capabilities");
                if (caps != null) {
                    for (String cap : this.capabilitiesFromWorkplaceAttribute(caps)) {
                        capsWp.put(cap, wpName);
                    }
                } else {
                    capsWp.put("", wpName);
                }
                if ((rebuildTimeS = e.attributeValue("rebuild-time")) == null) continue;
                wpRebuildTimes.put(wpName, Long.parseLong(rebuildTimeS));
            }
            ArrayList<Element> allEls = Lists.newArrayList();
            allEls.addAll(this.selectElems("//s:action[@type]"));
            allEls.addAll(this.selectElems("//s:cumulative-action[@type]"));
            TreeMap<RebuildType, RebuildType> globalRts = Maps.newTreeMap(RebuildType.fullComparator());
            for (Element e : allEls) {
                String type = e.attributeValue("type");
                String timeS = e.attributeValue("rebuild-time");
                long actionRebTime = -1L;
                if (timeS != null) {
                    actionRebTime = Long.parseLong(timeS);
                }
                String capReq = e.attributeValue("capability-req");
                for (String wp : Iterables.concat(capsWp.get(capReq), capsWp.get(""))) {
                    long time = actionRebTime >= 0L ? actionRebTime : wpRebuildTimes.getOrDefault(wp, 300000L);
                    RebuildType rt = new RebuildType(type, time, null);
                    if (globalRts.containsKey(rt)) {
                        rt = (RebuildType)globalRts.get(rt);
                    } else {
                        globalRts.put(rt, rt);
                    }
                    rt.setProperties(null, this.propdefs.get(RebuildType.class));
                    this.wpRebuildTypes.put(wp, rt);
                }
            }
            for (String wpName : Sets.newHashSet(this.wpRebuildTypes.keySet())) {
                Collection<RebuildType> wpRts = this.wpRebuildTypes.get(wpName);
                ImmutableListMultimap wpIndex = Multimaps.index(wpRts, RebuildType::getName);
                wpRts.clear();
                for (Collection rts : wpIndex.asMap().values()) {
                    RebuildType rtMax = null;
                    for (RebuildType rt : rts) {
                        if (rtMax != null && rt.getTime() <= rtMax.getTime()) continue;
                        rtMax = rt;
                    }
                    wpRts.add(rtMax);
                }
            }
        }

        private void resolveProducibles() {
            for (Material m3 : this.matprods) {
                if (!(m3 instanceof Product)) continue;
                for (Actiongram ag : ((Product)m3).getActiongrams()) {
                    for (Action a : ag.getActions()) {
                        a.resolveProducibles(this.matprodLut);
                    }
                }
            }
        }

        private void materialsFromXmlEl(Element el) throws InvalidXmlException {
            for (Element matEl : el.elements("material")) {
                this.addMatprod(this.materialFromXmlEl(matEl));
            }
        }

        private void matprodsFromXmlEl(Element el) throws InvalidXmlException {
            for (Element prodEl : el.elements("product")) {
                if (!this.matprodEls.containsKey(prodEl.attributeValue("name"))) continue;
                Product product = this.productFromXmlEl(prodEl);
                this.addMatprod(product);
                this.matprodEls.remove(product.getName());
                this.matprodStack.remove(product.getName());
            }
            if (!this.matprodEls.isEmpty()) {
                throw new RuntimeException("Something is terribly wrong, the map of references should be empty after processing all the products!");
            }
            if (!this.matprodStack.isEmpty()) {
                throw new RuntimeException("Something is terribly wrong, the stack should be empty after processing all the products!");
            }
        }

        private List<Workplace> workplacesFromXmlEl(Element el) throws InvalidXmlException {
            ArrayList<Workplace> workplaces = new ArrayList<Workplace>();
            for (Element workplEl : el.elements("workplace")) {
                workplaces.add(this.workplaceFromXmlEl(workplEl));
            }
            return workplaces;
        }

        private static HashMap<String, Element> matprodRefs(Element el) {
            HashMap<String, Element> refs = new HashMap<String, Element>();
            for (Element matprodEl : el.elements("product")) {
                refs.put(matprodEl.attributeValue("name"), matprodEl);
            }
            return refs;
        }

        private static HashSet<String> checkDuplicates(Element el) {
            String name;
            HashSet<String> known = new HashSet<String>();
            HashSet<String> duplicates = new HashSet<String>();
            for (Element matEl : el.element("materials").elements("material")) {
                name = matEl.attributeValue("name");
                if (known.contains(name)) {
                    duplicates.add(name);
                    continue;
                }
                known.add(name);
            }
            for (Element prodEl : el.element("products").elements("product")) {
                name = prodEl.attributeValue("name");
                if (known.contains(name)) {
                    duplicates.add(name);
                    continue;
                }
                known.add(name);
            }
            return duplicates;
        }

        private Workplace workplaceFromXmlEl(Element el) throws InvalidXmlException {
            String name = el.attributeValue("name");
            String capabilities = el.attributeValue("capabilities");
            String rebuildTypes = el.attributeValue("rebuild-types");
            String isCumS = el.attributeValue("is-cumulative");
            boolean cumulative = "true".equalsIgnoreCase(isCumS) || "1".equals(isCumS);
            String description = el.attributeValue("description");
            Workplace.Builder bob = new Workplace.Builder();
            bob.setName(name);
            bob.setCumulative(cumulative);
            bob.addCapabilities(this.capabilitiesFromWorkplaceAttribute(capabilities));
            if (description != null) {
                bob.setDescription(description);
            }
            if (!Strings.isNullOrEmpty(rebuildTypes)) {
                StringTokenizer st = new StringTokenizer(rebuildTypes);
                while (st.hasMoreTokens()) {
                    String rtId = st.nextToken();
                    RebuildType rt = this.rebuildTypes.get(rtId);
                    if (rt == null) {
                        throw new InvalidXmlException(String.format("Unknown rebuild id %s referenced from workplace %s.", rtId, name));
                    }
                    if (bob.addRebuildType(rt)) continue;
                    throw new InvalidXmlException(String.format("Duplicate rebuild type %s found at workplace %s.", rt.getName(), name));
                }
            } else if (this.wpRebuildTypes.containsKey(name)) {
                for (RebuildType rt : this.wpRebuildTypes.get(name)) {
                    bob.addRebuildType(rt);
                }
            }
            Workplace wp = bob.build();
            Element propsEl = el.element("properties");
            if (propsEl != null) {
                wp.setProperties(this.propertiesFromXmlEl(propsEl, Workplace.class), this.propdefs.get(Workplace.class));
            } else {
                wp.setProperties(null, this.propdefs.get(Workplace.class));
            }
            return wp;
        }

        private Collection<String> capabilitiesFromWorkplaceAttribute(String caps) throws InvalidXmlException {
            HashSet<String> capabilities = Sets.newHashSet();
            if (caps != null) {
                boolean escaped = false;
                StringBuilder item = new StringBuilder();
                for (int i = 0; i < caps.length(); ++i) {
                    if (caps.charAt(i) == '\\') {
                        if (escaped) {
                            item.append("\\");
                            escaped = false;
                            continue;
                        }
                        escaped = true;
                        continue;
                    }
                    if (caps.charAt(i) == ',') {
                        if (escaped) {
                            item.append(",");
                            escaped = false;
                            continue;
                        }
                        String itemS = item.toString();
                        if (!itemS.isEmpty()) {
                            capabilities.add(itemS);
                        }
                        item = new StringBuilder();
                        continue;
                    }
                    if (escaped) {
                        throw new InvalidXmlException("Unexpected escape character in capabilities string \"" + caps + "\" at char " + i);
                    }
                    item.append(caps.charAt(i));
                }
                if (escaped) {
                    throw new InvalidXmlException("Unexpected escape character in capabilities string \"" + caps + "\" at char " + (caps.length() - 1));
                }
                if (!item.toString().isEmpty()) {
                    capabilities.add(item.toString());
                }
            }
            return capabilities;
        }

        Material materialFromXmlEl(Element el) throws InvalidXmlException {
            this.parseMaterialAttributes(el, this.materialBob);
            Material mat = this.materialBob.build();
            Element propsEl = el.element("properties");
            if (propsEl != null) {
                mat.setProperties(this.propertiesFromXmlEl(propsEl, Material.class), this.propdefs.get(Material.class));
            } else {
                mat.setProperties(null, this.propdefs.get(Material.class));
            }
            return mat;
        }

        private void parseMaterialAttributes(Element el, Material.Builder b) {
            String name = el.attributeValue("name");
            String description = el.attributeValue("description");
            String matHorizonS = el.attributeValue("mat-horizon");
            String isConsumedS = el.attributeValue("consumed");
            String isConstantS = el.attributeValue("constant");
            String minBatchS = el.attributeValue("min-batch");
            String maxBatchS = el.attributeValue("max-batch");
            String batchStepS = el.attributeValue("batch-step");
            String safetyStockS = el.attributeValue("safety-stock");
            String aggregationHorizonS = el.attributeValue("agg-horizon");
            b.reset();
            b.setName(name);
            b.setDescription(description);
            if (matHorizonS != null) {
                b.setMaterialHorizon(Long.parseLong(matHorizonS));
            }
            if (isConsumedS != null) {
                b.setConsumed(Boolean.parseBoolean(isConsumedS));
            }
            if (isConstantS != null) {
                b.setConstant(Boolean.parseBoolean(isConstantS));
            }
            if (minBatchS != null) {
                b.setMinBatch(Double.parseDouble(minBatchS));
            }
            if (maxBatchS != null) {
                b.setMaxBatch(Double.parseDouble(maxBatchS));
            }
            if (batchStepS != null) {
                b.setBatchStep(Double.parseDouble(batchStepS));
            }
            if (safetyStockS != null) {
                b.setSafetyStock(Double.parseDouble(safetyStockS));
            }
            if (aggregationHorizonS != null) {
                b.setAggregationHorizon(Long.parseLong(aggregationHorizonS));
            }
        }

        Product productFromXmlEl(Element el) throws InvalidXmlException {
            this.parseMaterialAttributes(el, this.productBob);
            Product product = this.productBob.build();
            Element propsEl = el.element("properties");
            if (propsEl != null) {
                product.setProperties(this.propertiesFromXmlEl(propsEl, Product.class), this.propdefs.get(Product.class));
            } else {
                product.setProperties(null, this.propdefs.get(Product.class));
            }
            ArrayList<Actiongram> agrams = new ArrayList<Actiongram>();
            HashSet<String> agramNames = new HashSet<String>();
            for (Element actiongramEl : el.elements("actiongram")) {
                String actiongramName = actiongramEl.attributeValue("name", "");
                if (!agramNames.add(actiongramName)) {
                    throw new InvalidXmlException("Duplicate actiongram name " + actiongramName + " for product " + product.getName());
                }
                ArrayList<Action> actions = new ArrayList<Action>();
                Iterator<Element> aitel = actiongramEl.elements().iterator();
                while (aitel.hasNext()) {
                    Element actionEl = aitel.next();
                    Action action = "local-alt-group".equals(actionEl.getName()) ? this.lagFromXmlEl(actionEl, product, !aitel.hasNext()) : this.actionFromXmlEl(actionEl, product, !aitel.hasNext(), null);
                    actions.add(action);
                }
                agrams.add(new Actiongram(actions, actiongramName));
            }
            product.changeActiongrams(agrams);
            return product;
        }

        private Action lagFromXmlEl(Element el, Product product, boolean isLastAction) throws InvalidXmlException {
            Preconditions.checkArgument(el.getName().equals("local-alt-group"));
            String actionName = el.attributeValue("name");
            LocalAlternativeGroup.Builder bob = LocalAlternativeGroup.builder();
            Iterator<Element> iterator = el.elements().iterator();
            while (iterator.hasNext()) {
                Element actionElO;
                Element actionEl = actionElO = iterator.next();
                Action action = this.actionFromXmlEl(actionEl, product, isLastAction, actionName);
                bob.addAction(action);
            }
            return bob.build();
        }

        private Action actionFromXmlEl(Element el, Product product, boolean isLastAction, @Nullable String actionName) throws InvalidXmlException {
            Action.Builder bob;
            boolean isCumulative = el.getName().equals("cumulative-action");
            String name = el.attributeValue("name");
            String description = el.attributeValue("description");
            String type = el.attributeValue("type");
            String capabilityReq = el.attributeValue("capability-req");
            String timeToPrepareS = el.attributeValue("time-to-prepare");
            long timeToPrepare = 0L;
            if (timeToPrepareS != null) {
                timeToPrepare = Long.parseLong(timeToPrepareS);
            }
            String maxTimeToPrepareS = el.attributeValue("max-time-to-prepare");
            long maxTimeToPrepare = -1L;
            if (maxTimeToPrepareS != null) {
                maxTimeToPrepare = Long.parseLong(maxTimeToPrepareS);
            }
            String transferBatchS = el.attributeValue("transfer-batch");
            double transferBatch = -1.0;
            if (transferBatchS != null) {
                transferBatch = Double.parseDouble(transferBatchS);
            }
            long productionTime = Long.parseLong(el.attributeValue("production-time"));
            String granularityS = el.attributeValue("granularity");
            double granularity = 1.0;
            if (granularityS != null) {
                granularity = Double.parseDouble(granularityS);
            }
            String divisibilityS = el.attributeValue("divisibility");
            Action.Divisibility divisibility = Action.Divisibility.DIVISIBLE;
            if (divisibilityS != null) {
                divisibility = Action.Divisibility.valueOf(divisibilityS);
            }
            String qtyCoefS = el.attributeValue("qty-coef");
            double qtyCoef = 1.0;
            if (qtyCoefS != null) {
                qtyCoef = Double.parseDouble(qtyCoefS);
            }
            String isJoinedS = el.attributeValue("joined");
            boolean isJoined = false;
            if (isJoinedS != null) {
                isJoined = Boolean.parseBoolean(isJoinedS);
            }
            String cumType = null;
            double fill = 0.0;
            Double maxFill = null;
            if (isCumulative) {
                cumType = el.attributeValue("cumulation-type");
                fill = Double.parseDouble(el.attributeValue("fill"));
                String maxFillS = el.attributeValue("max-fill");
                if (maxFillS != null) {
                    maxFill = Double.parseDouble(maxFillS);
                }
            }
            Element bomEl = el.element("bom");
            Bom bom = this.bomFromXmlEl(bomEl);
            Element prodsEl = el.element("producing");
            ArrayList<Triple<String, Double, Double>> prods = new ArrayList<Triple<String, Double, Double>>();
            if (prodsEl != null) {
                Iterator<Element> i = prodsEl.elementIterator("material");
                while (i.hasNext()) {
                    Element bomLineEl = i.next();
                    String prodName = bomLineEl.attributeValue("name");
                    Double prodQty = Double.parseDouble(bomLineEl.attributeValue("q"));
                    String batchStr = bomLineEl.attributeValue("batch");
                    double prodBatch = 0.0;
                    if (batchStr != null) {
                        prodBatch = Double.parseDouble(batchStr);
                    }
                    prods.add(new Triple<String, Double, Double>(prodName, prodQty, prodBatch));
                }
            } else if (isLastAction) {
                prods.add(new Triple<String, Double, Double>(product.getName(), 1.0, 0.0));
            }
            if (isCumulative) {
                CumulativeAction.Builder cumBob = new CumulativeAction.Builder();
                cumBob.setCumulationType(cumType);
                cumBob.setFill(fill);
                if (maxFill != null) {
                    cumBob.setMaxFill(maxFill);
                }
                bob = cumBob;
            } else {
                bob = new Action.Builder();
            }
            if (actionName == null) {
                bob.setName(name);
            } else {
                bob.setName(actionName);
                bob.setLocalAltName(name);
            }
            bob.setDescription(description);
            bob.setProduct(product);
            bob.setBom(bom);
            bob.setProductionTime(productionTime);
            bob.setRebuildType(type);
            bob.setCapabilityReq(capabilityReq);
            bob.setMinTimeToPrepare(timeToPrepare);
            bob.setMaxTimeToPrepare(maxTimeToPrepare);
            bob.setTransferBatch(transferBatch);
            bob.setProducesNames(prods);
            bob.setDivisibility(divisibility);
            bob.setGranularity(granularity);
            bob.setQtyCoef(qtyCoef);
            bob.setJoinedWithFollowing(isJoined);
            Action action = bob.build();
            Element propsEl = el.element("properties");
            if (propsEl != null) {
                action.setProperties(this.propertiesFromXmlEl(propsEl, Action.class), this.propdefs.get(Action.class));
            } else {
                action.setProperties(null, this.propdefs.get(Action.class));
            }
            return action;
        }

        private Bom bomFromXmlEl(Element bomEl) throws InvalidXmlException {
            String bomName = "";
            ArrayList<MaterialQuantity> ingredients = new ArrayList<MaterialQuantity>();
            if (bomEl != null) {
                String bomXName = bomEl.attributeValue("name");
                if (bomXName != null) {
                    bomName = bomXName;
                }
                Iterator<Element> i = bomEl.elementIterator();
                while (i.hasNext()) {
                    Element bomLineEl = i.next();
                    if (bomLineEl.getName().equals("material")) {
                        ingredients.add(this.materialReqFromXml(bomLineEl));
                        continue;
                    }
                    throw new InvalidXmlException("Unknown tag name in BOM description.");
                }
            }
            return new Bom(ingredients, bomName);
        }

        private MaterialQuantity materialReqFromXml(Element bomLineEl) throws InvalidXmlException {
            Material mat;
            String materialName = bomLineEl.attributeValue("name");
            double q = Double.parseDouble(bomLineEl.attributeValue("q"));
            String batchStr = bomLineEl.attributeValue("batch");
            double batch = 0.0;
            if (batchStr != null) {
                batch = Double.parseDouble(batchStr);
            }
            if ((mat = this.getMaterial(materialName)) == null) {
                if (this.matprodEls.containsKey(materialName)) {
                    if (this.matprodStack.contains(materialName)) {
                        throw new InvalidXmlException("The XML description can not contain cycles in actiongrams! " + this.matprodStack);
                    }
                    this.matprodStack.add(materialName);
                    Product producibleMaterial = this.productFromXmlEl(this.matprodEls.get(materialName));
                    this.addMatprod(producibleMaterial);
                    this.matprodEls.remove(materialName);
                    this.matprodStack.remove(materialName);
                    return new MaterialQuantity(producibleMaterial, q, batch);
                }
                throw new InvalidXmlException("Unknown material " + bomLineEl.attributeValue("name"));
            }
            return new MaterialQuantity(mat, q, batch);
        }

        private Material getMaterial(String name) {
            return this.matprodLut.get(name);
        }

        private void addMatprod(Material matprod) {
            this.matprods.add(matprod);
            this.matprodLut.put(matprod.getName(), matprod);
        }
    }

    public static class ShopConfWriter {
        private final ShopConfiguration configuration;
        private final Set<Material> onlyMatprods;
        private XMLStreamWriter xw;
        private Map<RebuildType, String> rtIds = Maps.newIdentityHashMap();
        private static XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        private static final String XML_ENCODING = "utf-8";

        public ShopConfWriter(ShopConfiguration configuration) {
            this(configuration, null);
        }

        public ShopConfWriter(ShopConfiguration configuration, Set<Material> onlyMatprods) {
            this.configuration = Preconditions.checkNotNull(configuration, "Configuration cannot be null.");
            this.onlyMatprods = onlyMatprods;
        }

        public void writeConfiguration(OutputStream out) throws XMLStreamException {
            this.xw = outputFactory.createXMLStreamWriter(out, XML_ENCODING);
            this.writeConfig();
            this.xw.close();
        }

        public void writeConfiguration(Writer writer) throws XMLStreamException {
            this.xw = outputFactory.createXMLStreamWriter(writer);
            this.writeConfig();
            this.xw.close();
        }

        private void writeConfig() throws XMLStreamException {
            this.xw.writeStartDocument();
            this.xw.setDefaultNamespace(ShopSerializer.SHOP_NS_URI);
            this.xw.writeStartElement("shop");
            this.xw.writeDefaultNamespace(ShopSerializer.SHOP_NS_URI);
            this.xw.writeNamespace("xsi", ShopSerializer.XSD_NS_URI);
            this.xw.writeAttribute(ShopSerializer.XSD_NS_URI, "schemaLocation", ShopSerializer.SHOP_XSD_URI);
            this.writeMaterials();
            this.writeProducts();
            this.writeRebuildTypes();
            this.writeWorkplaces();
            this.writePropdefs();
            this.xw.writeEndElement();
            this.xw.writeEndDocument();
        }

        private void writeMaterials() throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("materials");
            for (Material mat : this.configuration.getMaterials()) {
                if (this.onlyMatprods != null && !this.onlyMatprods.contains(mat)) continue;
                boolean hasProperties = !mat.getProperties().isEmpty();
                this.xw.writeCharacters("\n ");
                if (hasProperties) {
                    this.xw.writeStartElement("material");
                } else {
                    this.xw.writeEmptyElement("material");
                }
                this.writeMaterialAttrsAndProps(mat);
                if (!hasProperties) continue;
                this.xw.writeEndElement();
            }
            this.xw.writeCharacters("\n");
            this.xw.writeEndElement();
        }

        private void writeMaterialAttrsAndProps(Material mat) throws XMLStreamException {
            this.xw.writeAttribute("name", mat.getName());
            if (!mat.getDescription().isEmpty()) {
                this.xw.writeAttribute("description", mat.getDescription());
            }
            if (GeneralizedRequest.isDateValid(mat.getMaterialHorizon())) {
                this.xw.writeAttribute("mat-horizon", Long.toString(mat.getMaterialHorizon()));
            }
            if (mat.isConstant()) {
                this.xw.writeAttribute("constant", "true");
            }
            if (!mat.isConsumed()) {
                this.xw.writeAttribute("consumed", "false");
            }
            if (mat.getMinBatch() != 0.0) {
                this.xw.writeAttribute("min-batch", "" + mat.getMinBatch());
            }
            if (mat.getMaxBatch() != -1.0) {
                this.xw.writeAttribute("max-batch", "" + mat.getMaxBatch());
            }
            if (mat.getBatchStep() != 1.0) {
                this.xw.writeAttribute("batch-step", "" + mat.getBatchStep());
            }
            if (mat.getSafetyStock() != 0.0) {
                this.xw.writeAttribute("safety-stock", "" + mat.getSafetyStock());
            }
            if (mat.getAggregationHorizon() != 0L) {
                this.xw.writeAttribute("agg-horizon", "" + mat.getAggregationHorizon());
            }
            if (!mat.getProperties().isEmpty()) {
                this.writeProperties(mat.getProperties());
            }
        }

        private void writeProducts() throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("products");
            for (Product product : this.configuration.getProducts()) {
                if (this.onlyMatprods != null && !this.onlyMatprods.contains(product)) continue;
                this.writeProduct(product);
            }
            this.xw.writeEndElement();
        }

        private void writeProduct(Product product) throws XMLStreamException {
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("product");
            this.writeMaterialAttrsAndProps(product);
            for (Actiongram actiongram : product.getActiongrams()) {
                this.xw.writeCharacters("\n ");
                this.xw.writeStartElement("actiongram");
                if (!"".equals(actiongram.getName())) {
                    this.xw.writeAttribute("name", actiongram.getName());
                }
                Action lastAction = actiongram.getRootAction();
                for (Action ac : actiongram.getActions()) {
                    boolean isLastAction;
                    boolean bl = isLastAction = ac == lastAction;
                    if (ac.hasLocalAlts()) {
                        this.writeLag(ac, product, isLastAction);
                        continue;
                    }
                    this.writeAction(ac, product, isLastAction);
                }
                this.xw.writeEndElement();
            }
            this.xw.writeEndElement();
        }

        private void writeLag(Action ac, Product product, boolean isLastAction) throws XMLStreamException {
            this.xw.writeCharacters("\n  ");
            this.xw.writeStartElement("local-alt-group");
            this.xw.writeAttribute("name", ac.getName());
            for (Action alt : ac.getLocalAlts()) {
                this.writeAction(alt, product, isLastAction);
            }
            this.xw.writeEndElement();
        }

        private void writeAction(Action ac, Product product, boolean isLastAction) throws XMLStreamException {
            Bom bom;
            if (ac.hasLocalAlts()) {
                this.xw.writeCharacters("\n   ");
            } else {
                this.xw.writeCharacters("\n  ");
            }
            if (ac instanceof CumulativeAction) {
                this.xw.writeStartElement("cumulative-action");
            } else {
                this.xw.writeStartElement("action");
            }
            this.xw.writeAttribute("name", ac.hasLocalAlts() ? ac.getLocalAltName() : ac.getName());
            if (!Strings.isNullOrEmpty(ac.getDescription())) {
                this.xw.writeAttribute("description", ac.getDescription());
            }
            this.xw.writeAttribute("type", ac.getRebuildType());
            if (ac.getCapabilityReq() != null) {
                this.xw.writeAttribute("capability-req", ac.getCapabilityReq());
            }
            if (ac.getMinTimeToPrepare() != 0L) {
                this.xw.writeAttribute("time-to-prepare", Long.toString(ac.getMinTimeToPrepare()));
            }
            if (ac.getMaxTimeToPrepare() != -1L) {
                this.xw.writeAttribute("max-time-to-prepare", Long.toString(ac.getMaxTimeToPrepare()));
            }
            if (ac.getTransferBatch() >= 0.0) {
                this.xw.writeAttribute("transfer-batch", Double.toString(ac.getTransferBatch()));
            }
            if (ac.getGranularity() != 1.0) {
                this.xw.writeAttribute("granularity", Double.toString(ac.getGranularity()));
            }
            if (ac.getDivisibility() != Action.Divisibility.DIVISIBLE) {
                this.xw.writeAttribute("divisibility", ac.getDivisibility().name());
            }
            if (ac.getQtyCoef() != 1.0) {
                this.xw.writeAttribute("qty-coef", Double.toString(ac.getQtyCoef()));
            }
            if (ac.isJoinedWithFollowing()) {
                this.xw.writeAttribute("joined", "true");
            }
            this.xw.writeAttribute("production-time", Long.toString(ac.getProductionTime()));
            if (ac instanceof CumulativeAction) {
                this.xw.writeAttribute("cumulation-type", ((CumulativeAction)ac).getCumulationType());
                this.xw.writeAttribute("fill", Double.toString(((CumulativeAction)ac).getFill()));
                this.xw.writeAttribute("max-fill", Double.toString(((CumulativeAction)ac).getMaxFill()));
            }
            if (!((bom = ac.getBom()) == null || "".equals(bom.getName()) && bom.size() <= 0)) {
                this.writeBom(bom);
            }
            if (isLastAction && (ac.getProduces().size() != 1 || ac.getProduces().get(0).getMaterial() != product || ac.getProduces().get(0).getQty() != 1.0 || ac.getProduces().get(0).getBatch() != 0.0) || !isLastAction && ac.getProduces().size() > 0) {
                this.xw.writeCharacters("\n   ");
                this.xw.writeStartElement("producing");
                for (MaterialQuantity pi : ac.getProduces()) {
                    this.writeMaterialQuantity(pi);
                }
                this.xw.writeEndElement();
            }
            if (!ac.getProperties().isEmpty()) {
                this.writeProperties(ac.getProperties());
            }
            this.xw.writeEndElement();
        }

        private void writeBom(Bom bom) throws XMLStreamException {
            this.xw.writeCharacters("\n   ");
            this.xw.writeStartElement("bom");
            if (!"".equals(bom.getName())) {
                this.xw.writeAttribute("name", bom.getName());
            }
            for (MaterialQuantity ingredient : bom) {
                this.writeMaterialQuantity(ingredient);
            }
            this.xw.writeEndElement();
        }

        private void writeMaterialQuantity(MaterialQuantity producingItem) throws XMLStreamException {
            this.xw.writeCharacters("\n    ");
            this.xw.writeEmptyElement("material");
            this.xw.writeAttribute("name", producingItem.getMaterial().getName());
            this.xw.writeAttribute("q", "" + producingItem.getQty());
            if (Math.abs(producingItem.getBatch()) > 1.0E-7) {
                this.xw.writeAttribute("batch", "" + producingItem.getBatch());
            }
        }

        private void writeWorkplaces() throws XMLStreamException {
            StringBuilder sb = new StringBuilder();
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("workplaces");
            for (Workplace wp : this.configuration.getWorkplaces()) {
                boolean hasProperties = !wp.getProperties().isEmpty();
                this.xw.writeCharacters("\n ");
                if (hasProperties) {
                    this.xw.writeStartElement("workplace");
                } else {
                    this.xw.writeEmptyElement("workplace");
                }
                this.xw.writeAttribute("name", wp.getName());
                if (wp.getCapabilities().size() > 0) {
                    sb.setLength(0);
                    for (String cap : wp.getCapabilities()) {
                        String escaped = cap.replaceAll("\\\\", "\\\\\\\\");
                        escaped = escaped.replaceAll(",", "\\\\,");
                        sb.append(escaped);
                        sb.append(',');
                    }
                    sb.setLength(sb.length() - 1);
                    this.xw.writeAttribute("capabilities", sb.toString());
                }
                if (wp.isCumulative()) {
                    this.xw.writeAttribute("is-cumulative", "true");
                }
                if (wp.getDescription() != null && !wp.getDescription().trim().equals("")) {
                    this.xw.writeAttribute("description", wp.getDescription());
                }
                if (!wp.getRebuildTypes().isEmpty()) {
                    sb.setLength(0);
                    for (RebuildType rt : wp.getRebuildTypes()) {
                        sb.append(this.rtIds.get(rt));
                        sb.append(' ');
                    }
                    sb.setLength(sb.length() - 1);
                    this.xw.writeAttribute("rebuild-types", sb.toString());
                }
                if (!hasProperties) continue;
                this.writeProperties(wp.getProperties());
                this.xw.writeEndElement();
            }
            this.xw.writeCharacters("\n");
            this.xw.writeEndElement();
        }

        private void writeRebuildTypes() throws XMLStreamException {
            ArrayList<RebuildType> rts = Lists.newArrayList(this.configuration.getRebuildTypes());
            rts.sort(RebuildType.fullComparator());
            this.xw.writeCharacters("\n");
            this.xw.writeStartElement("rebuild-types");
            int i = 0;
            for (RebuildType rt : rts) {
                boolean hasBom;
                String rtId = "r" + i++;
                this.rtIds.put(rt, rtId);
                this.xw.writeCharacters("\n ");
                boolean hasProperties = !rt.getProperties().isEmpty();
                boolean bl = hasBom = rt.getBom().size() > 0;
                if (hasProperties || hasBom) {
                    this.xw.writeStartElement("rebuild-type");
                } else {
                    this.xw.writeEmptyElement("rebuild-type");
                }
                this.xw.writeAttribute("name", rt.getName());
                this.xw.writeAttribute("time", Long.toString(rt.getTime()));
                this.xw.writeAttribute("rid", rtId);
                if (hasProperties) {
                    this.writeProperties(rt.getProperties());
                }
                if (hasBom) {
                    this.writeBom(rt.getBom());
                }
                if (!hasProperties && !hasBom) continue;
                this.xw.writeEndElement();
            }
            this.xw.writeCharacters("\n");
            this.xw.writeEndElement();
        }

        private void writePropdefs() throws XMLStreamException {
            HashSet<Class<? extends Propertized>> effctivities = Sets.newHashSet();
            for (PropertyDefinition pd : this.configuration.getPropertyDefinitions()) {
                effctivities.add(pd.getEffectivity());
            }
            ArrayList<Class> sortedEffectivities = Lists.newArrayList(effctivities);
            Collections.sort(sortedEffectivities, Comparator.comparing(Class::getCanonicalName));
            if (sortedEffectivities.size() > 0) {
                this.xw.writeCharacters("\n");
                this.xw.writeStartElement("property-definitions");
                for (Class pe : sortedEffectivities) {
                    ArrayList<PropertyDefinition> sortedPropdefs = Lists.newArrayList(this.configuration.getPropertyDefinitionsFor(pe));
                    Collections.sort(sortedPropdefs, Comparator.comparing(PropertyDefinition::getName));
                    for (PropertyDefinition pd : this.configuration.getPropertyDefinitionsFor(pe)) {
                        this.xw.writeCharacters("\n ");
                        this.xw.writeEmptyElement("property-definition");
                        this.xw.writeAttribute("name", pd.getName());
                        this.xw.writeAttribute("label", pd.getLabel());
                        this.xw.writeAttribute("type", pd.getType().toString());
                        this.xw.writeAttribute("effectivity", (String)PropertyDefinition.PROPERTY_EFFECTIVITY_NAMES.get(pd.getEffectivity()));
                        if (pd.getDescription().length() > 0) {
                            this.xw.writeAttribute("description", pd.getDescription());
                        }
                        this.xw.writeAttribute("visible", Boolean.toString(pd.isVisible()));
                    }
                }
                this.xw.writeCharacters("\n");
                this.xw.writeEndElement();
            }
        }

        private void writeProperties(Map<PropertyDefinition, Object> properties) throws XMLStreamException {
            if (properties.size() > 0) {
                this.xw.writeCharacters("\n");
                this.xw.writeStartElement("properties");
                for (Map.Entry<PropertyDefinition, Object> prop : properties.entrySet()) {
                    PropertyDefinition pd = prop.getKey();
                    Object value = prop.getValue();
                    this.xw.writeCharacters("\n ");
                    this.xw.writeEmptyElement("property");
                    this.xw.writeAttribute("name", pd.getName());
                    this.xw.writeAttribute("value", pd.getType().asString(value));
                }
                this.xw.writeEndElement();
            }
        }
    }
}

